/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.xml;

import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import org.fife.rsta.ac.AbstractMarkupLanguageSupport;
import org.fife.rsta.ac.GoToMemberAction;
import org.fife.rsta.ac.xml.XmlParser;
import org.fife.rsta.ac.xml.tree.XmlOutlineTree;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.parser.Parser;

public class XmlLanguageSupport
extends AbstractMarkupLanguageSupport {
    private boolean showSyntaxErrors;

    public XmlLanguageSupport() {
        this.setAutoCompleteEnabled(false);
        this.setParameterAssistanceEnabled(false);
        this.setShowDescWindow(false);
        this.setShowSyntaxErrors(true);
    }

    public XmlParser getParser(RSyntaxTextArea textArea) {
        Object parser = textArea.getClientProperty((Object)"org.fife.rsta.ac.LanguageSupport.LanguageParser");
        if (parser instanceof XmlParser) {
            return (XmlParser)((Object)parser);
        }
        return null;
    }

    public boolean getShowSyntaxErrors() {
        return this.showSyntaxErrors;
    }

    @Override
    public void install(RSyntaxTextArea textArea) {
        XmlParser parser = new XmlParser(this);
        textArea.addParser((Parser)parser);
        textArea.putClientProperty((Object)"org.fife.rsta.ac.LanguageSupport.LanguageParser", (Object)parser);
        this.installKeyboardShortcuts(textArea);
    }

    @Override
    protected void installKeyboardShortcuts(RSyntaxTextArea textArea) {
        super.installKeyboardShortcuts(textArea);
        InputMap im = textArea.getInputMap();
        ActionMap am = textArea.getActionMap();
        int c = textArea.getToolkit().getMenuShortcutKeyMask();
        int shift = 1;
        im.put(KeyStroke.getKeyStroke(79, c | shift), "GoToType");
        am.put("GoToType", new GoToMemberAction(XmlOutlineTree.class));
    }

    public void setShowSyntaxErrors(boolean show) {
        this.showSyntaxErrors = show;
    }

    @Override
    protected boolean shouldAutoCloseTag(String tag) {
        return true;
    }

    @Override
    public void uninstall(RSyntaxTextArea textArea) {
        this.uninstallImpl(textArea);
        XmlParser parser = this.getParser(textArea);
        if (parser != null) {
            textArea.removeParser((Parser)parser);
        }
        this.uninstallKeyboardShortcuts(textArea);
    }

    @Override
    protected void uninstallKeyboardShortcuts(RSyntaxTextArea textArea) {
        super.uninstallKeyboardShortcuts(textArea);
        InputMap im = textArea.getInputMap();
        ActionMap am = textArea.getActionMap();
        int c = textArea.getToolkit().getMenuShortcutKeyMask();
        int shift = 1;
        im.remove(KeyStroke.getKeyStroke(79, c | shift));
        am.remove("GoToType");
    }
}

