/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.js.tree;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.fife.rsta.ac.AbstractSourceTree;
import org.fife.rsta.ac.LanguageSupport;
import org.fife.rsta.ac.LanguageSupportFactory;
import org.fife.rsta.ac.js.IconFactory;
import org.fife.rsta.ac.js.JavaScriptLanguageSupport;
import org.fife.rsta.ac.js.JavaScriptParser;
import org.fife.rsta.ac.js.tree.JavaScriptTreeCellRenderer;
import org.fife.rsta.ac.js.tree.JavaScriptTreeNode;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.ast.AstNode;
import org.mozilla.javascript.ast.AstRoot;
import org.mozilla.javascript.ast.FunctionNode;
import org.mozilla.javascript.ast.Name;
import org.mozilla.javascript.ast.VariableDeclaration;
import org.mozilla.javascript.ast.VariableInitializer;

public class JavaScriptOutlineTree
extends AbstractSourceTree {
    private DefaultTreeModel model;
    private RSyntaxTextArea textArea;
    private JavaScriptParser parser;
    private Listener listener;
    private static final int PRIORITY_FUNCTION = 1;
    private static final int PRIORITY_VARIABLE = 2;

    public JavaScriptOutlineTree() {
        this(false);
    }

    public JavaScriptOutlineTree(boolean sorted) {
        this.setSorted(sorted);
        this.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 8));
        this.setRootVisible(false);
        this.setCellRenderer(new JavaScriptTreeCellRenderer());
        this.model = new DefaultTreeModel(new DefaultMutableTreeNode("Nothing"));
        this.setModel(this.model);
        this.listener = new Listener();
        this.addTreeSelectionListener(this.listener);
    }

    private void checkForJavaScriptParsing() {
        if (this.parser != null) {
            this.parser.removePropertyChangeListener("AST", this.listener);
            this.parser = null;
        }
        LanguageSupportFactory lsf = LanguageSupportFactory.get();
        LanguageSupport support = lsf.getSupportFor("text/javascript");
        JavaScriptLanguageSupport jls = (JavaScriptLanguageSupport)support;
        this.parser = jls.getParser(this.textArea);
        if (this.parser != null) {
            this.parser.addPropertyChangeListener("AST", this.listener);
            AstRoot ast = this.parser.getAstRoot();
            this.update(ast);
        } else {
            this.update((AstRoot)null);
        }
    }

    @Override
    public void expandInitialNodes() {
        int j = 0;
        while (j < this.getRowCount()) {
            this.collapseRow(j++);
        }
        this.expandRow(0);
    }

    private void gotoElementAtPath(TreePath path) {
        JavaScriptTreeNode jstn;
        int len;
        Object node = path.getLastPathComponent();
        if (node instanceof JavaScriptTreeNode && (len = (jstn = (JavaScriptTreeNode)node).getLength()) > -1) {
            int offs = jstn.getOffset();
            this.textArea.select(offs, offs + len);
        }
    }

    @Override
    public boolean gotoSelectedElement() {
        TreePath path = this.getLeadSelectionPath();
        if (path != null) {
            this.gotoElementAtPath(path);
            return true;
        }
        return false;
    }

    @Override
    public void listenTo(RSyntaxTextArea textArea) {
        if (this.textArea != null) {
            this.uninstall();
        }
        if (textArea == null) {
            return;
        }
        this.textArea = textArea;
        textArea.addPropertyChangeListener("RSTA.syntaxStyle", (PropertyChangeListener)this.listener);
        this.checkForJavaScriptParsing();
    }

    @Override
    public void uninstall() {
        if (this.parser != null) {
            this.parser.removePropertyChangeListener("AST", this.listener);
            this.parser = null;
        }
        if (this.textArea != null) {
            this.textArea.removePropertyChangeListener("RSTA.syntaxStyle", (PropertyChangeListener)this.listener);
            this.textArea = null;
        }
    }

    private void update(AstRoot ast) {
        JavaScriptTreeNode root = new JavaScriptTreeNode(null);
        if (ast == null) {
            this.model.setRoot(root);
            return;
        }
        block14: for (Node child = ast.getFirstChild(); child != null; child = child.getNext()) {
            switch (child.getType()) {
                case 109: {
                    FunctionNode fn = (FunctionNode)child;
                    StringBuffer sb = new StringBuffer(fn.getName()).append('(');
                    int paramCount = fn.getParamCount();
                    if (paramCount > 0) {
                        List fnParams = fn.getParams();
                        for (int i = 0; i < paramCount; ++i) {
                            String paramName = null;
                            AstNode node = (AstNode)fnParams.get(i);
                            switch (node.getType()) {
                                case 39: {
                                    paramName = ((Name)node).getIdentifier();
                                    break;
                                }
                                default: {
                                    System.out.println("Unhandled class for param: " + node.getClass());
                                    paramName = "?";
                                }
                            }
                            sb.append(paramName);
                            if (i >= paramCount - 1) continue;
                            sb.append(", ");
                        }
                    }
                    sb.append(')');
                    JavaScriptTreeNode tn = new JavaScriptTreeNode((AstNode)fn.getFunctionName());
                    try {
                        int offs = fn.getFunctionName().getAbsolutePosition();
                        tn.setOffset(this.textArea.getDocument().createPosition(offs));
                    }
                    catch (BadLocationException ble) {
                        ble.printStackTrace();
                    }
                    tn.setText(sb.toString());
                    tn.setIcon(IconFactory.getIcon("default_function"));
                    tn.setSortPriority(1);
                    root.add(tn);
                    continue block14;
                }
                case 122: {
                    JavaScriptTreeNode tn;
                    VariableDeclaration varDec = (VariableDeclaration)child;
                    List vars = varDec.getVariables();
                    Iterator i = vars.iterator();
                    while (i.hasNext()) {
                        Name varNameNode = null;
                        String varName = null;
                        VariableInitializer var = (VariableInitializer)i.next();
                        AstNode target = var.getTarget();
                        switch (target.getType()) {
                            case 39: {
                                varNameNode = (Name)target;
                                varName = varNameNode.getIdentifier();
                                break;
                            }
                            default: {
                                System.out.println("... Unknown var target type: " + target.getClass());
                                varName = "?";
                            }
                        }
                        tn = new JavaScriptTreeNode((AstNode)varNameNode);
                        try {
                            int offs = varNameNode.getAbsolutePosition();
                            tn.setOffset(this.textArea.getDocument().createPosition(offs));
                        }
                        catch (BadLocationException ble) {
                            ble.printStackTrace();
                        }
                        tn.setText(varName);
                        tn.setIcon(IconFactory.getIcon("local_variable"));
                        tn.setSortPriority(2);
                        root.add(tn);
                    }
                    continue block14;
                }
            }
        }
        this.model.setRoot(root);
        root.setSorted(this.isSorted());
        this.refresh();
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setCellRenderer(new JavaScriptTreeCellRenderer());
    }

    private class Listener
    implements PropertyChangeListener,
    TreeSelectionListener {
        private Listener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            if ("RSTA.syntaxStyle".equals(name)) {
                JavaScriptOutlineTree.this.checkForJavaScriptParsing();
            } else if ("AST".equals(name)) {
                AstRoot ast = (AstRoot)e.getNewValue();
                JavaScriptOutlineTree.this.update(ast);
            }
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            TreePath newPath;
            if (JavaScriptOutlineTree.this.getGotoSelectedElementOnClick() && (newPath = e.getNewLeadSelectionPath()) != null) {
                JavaScriptOutlineTree.this.gotoElementAtPath(newPath);
            }
        }
    }
}

