/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.java.buildpath;

import java.io.File;
import java.io.IOException;
import java.util.TreeMap;
import org.fife.rsta.ac.java.Util;
import org.fife.rsta.ac.java.buildpath.LibraryInfo;
import org.fife.rsta.ac.java.buildpath.SourceLocation;
import org.fife.rsta.ac.java.classreader.ClassFile;

public class DirLibraryInfo
extends LibraryInfo {
    private File dir;

    public DirLibraryInfo(File dir) {
        this(dir, null);
    }

    public DirLibraryInfo(String dir) {
        this(new File(dir));
    }

    public DirLibraryInfo(File dir, SourceLocation sourceLoc) {
        this.setDirectory(dir);
        this.setSourceLocation(sourceLoc);
    }

    public DirLibraryInfo(String dir, SourceLocation sourceLoc) {
        this(new File(dir), sourceLoc);
    }

    public int compareTo(Object o) {
        if (o == this) {
            return 0;
        }
        int result = -1;
        if (o instanceof DirLibraryInfo) {
            return this.dir.compareTo(((DirLibraryInfo)o).dir);
        }
        return result;
    }

    @Override
    public ClassFile createClassFile(String entryName) throws IOException {
        File file = new File(this.dir, entryName);
        if (!file.isFile()) {
            System.err.println("ERROR: Invalid class file: " + file.getAbsolutePath());
            return null;
        }
        return new ClassFile(file);
    }

    @Override
    public TreeMap createPackageMap() throws IOException {
        TreeMap map = new TreeMap();
        this.getPackageMapImpl(this.dir, null, map);
        return map;
    }

    @Override
    public long getLastModified() {
        return this.dir.lastModified();
    }

    @Override
    public String getLocationAsString() {
        return this.dir.getAbsolutePath();
    }

    private void getPackageMapImpl(File dir, String pkg, TreeMap retVal) throws IOException {
        File[] children = dir.listFiles();
        TreeMap m = retVal;
        boolean firstTimeThrough = true;
        for (int i = 0; i < children.length; ++i) {
            File child = children[i];
            if (child.isFile() && child.getName().endsWith(".class")) {
                if (pkg != null && firstTimeThrough) {
                    firstTimeThrough = false;
                    String[] items = Util.splitOnChar(pkg, 47);
                    for (int j = 0; j < items.length; ++j) {
                        Object temp = m.get(items[j]);
                        if (temp instanceof TreeMap) {
                            m = (TreeMap)temp;
                            continue;
                        }
                        if (temp == null) {
                            TreeMap submap = new TreeMap();
                            m.put(items[j], submap);
                            m = submap;
                            continue;
                        }
                        return;
                    }
                }
                String className = child.getName().substring(0, child.getName().length() - 6);
                m.put(className, null);
                continue;
            }
            if (!child.isDirectory()) continue;
            String subpkg = pkg == null ? child.getName() : pkg + "/" + child.getName();
            this.getPackageMapImpl(child, subpkg, retVal);
        }
    }

    @Override
    public int hashCode() {
        return this.dir.hashCode();
    }

    private void setDirectory(File dir) {
        if (dir == null || !dir.isDirectory()) {
            String name = dir == null ? "null" : dir.getAbsolutePath();
            throw new IllegalArgumentException("Directory does not exist: " + name);
        }
        this.dir = dir;
    }

    public String toString() {
        return "[DirLibraryInfo: jar=" + this.dir.getAbsolutePath() + "; source=" + this.getSourceLocation() + "]";
    }
}

