/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.java.buildpath;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.fife.rsta.ac.java.Util;
import org.fife.rsta.ac.java.buildpath.LibraryInfo;
import org.fife.rsta.ac.java.buildpath.SourceLocation;
import org.fife.rsta.ac.java.classreader.ClassFile;

public class ClasspathLibraryInfo
extends LibraryInfo {
    private Map classNameToClassFile;

    public ClasspathLibraryInfo(String[] classes) {
        this(Arrays.asList(classes), null);
    }

    public ClasspathLibraryInfo(List classes) {
        this(classes, null);
    }

    public ClasspathLibraryInfo(List classes, SourceLocation sourceLoc) {
        this.setSourceLocation(sourceLoc);
        this.classNameToClassFile = new HashMap();
        int count = classes == null ? 0 : classes.size();
        for (int i = 0; i < count; ++i) {
            String entryName = (String)classes.get(i);
            entryName = entryName.replace('.', '/') + ".class";
            this.classNameToClassFile.put(entryName, null);
        }
    }

    public int compareTo(Object o) {
        if (o == this) {
            return 0;
        }
        int res = -1;
        if (o instanceof ClasspathLibraryInfo) {
            ClasspathLibraryInfo other = (ClasspathLibraryInfo)o;
            res = this.classNameToClassFile.size() - other.classNameToClassFile.size();
            if (res == 0) {
                for (String key : this.classNameToClassFile.keySet()) {
                    if (other.classNameToClassFile.containsKey(key)) continue;
                    res = -1;
                    break;
                }
            }
        }
        return res;
    }

    @Override
    public ClassFile createClassFile(String entryName) throws IOException {
        ClassFile cf = null;
        if (this.classNameToClassFile.containsKey(entryName) && (cf = (ClassFile)this.classNameToClassFile.get(entryName)) == null) {
            cf = this.createClassFileImpl(entryName);
            this.classNameToClassFile.put(entryName, cf);
        }
        return cf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassFile createClassFileImpl(String res) throws IOException {
        ClassFile cf = null;
        InputStream in = this.getClass().getClassLoader().getResourceAsStream(res);
        if (in != null) {
            DataInputStream din = null;
            try {
                BufferedInputStream bin = new BufferedInputStream(in);
                din = new DataInputStream(bin);
                cf = new ClassFile(din);
            }
            finally {
                in.close();
            }
        }
        return cf;
    }

    @Override
    public TreeMap createPackageMap() throws IOException {
        TreeMap packageMap = new TreeMap();
        for (String className : this.classNameToClassFile.keySet()) {
            String[] tokens = Util.splitOnChar(className, 47);
            TreeMap temp = packageMap;
            for (int j = 0; j < tokens.length - 1; ++j) {
                String pkg = tokens[j];
                TreeMap submap = (TreeMap)temp.get(pkg);
                if (submap == null) {
                    submap = new TreeMap();
                    temp.put(pkg, submap);
                }
                temp = submap;
            }
            className = tokens[tokens.length - 1];
            className = className.substring(0, className.length() - 6);
            temp.put(className, null);
        }
        return packageMap;
    }

    @Override
    public long getLastModified() {
        return 0L;
    }

    @Override
    public String getLocationAsString() {
        return null;
    }

    @Override
    public int hashCode() {
        return this.classNameToClassFile.hashCode();
    }
}

